/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.RopeKnotBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class RopeKnotBlock
extends MimicBlock
implements class_3737,
class_2343,
IRopeConnection,
IRotatable {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;
    public static final class_2754<ModBlockProperties.PostType> POST_TYPE = ModBlockProperties.POST_TYPE;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 EAST = class_2741.field_12487;
    private static Map<class_2680, class_265> shapeMap;
    private static Map<class_2680, class_265> collisionShapesMap;

    public RopeKnotBlock(class_4970.class_2251 properties) {
        super(properties);
        Pair<Map<class_2680, class_265>, Map<class_2680, class_265>> s = this.makeShapes();
        shapeMap = (Map)s.getFirst();
        collisionShapesMap = (Map)s.getSecond();
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11052)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(POST_TYPE, (Comparable)((Object)ModBlockProperties.PostType.POST))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, POST_TYPE, AXIS, NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new RopeKnotBlockTile(pPos, pState);
    }

    public boolean method_9543() {
        return true;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)class_25862;
            try {
                return tile.getShape();
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to get block shape for rope knot block at {}", (Object)pos);
            }
        }
        return super.method_9530(state, world, pos, context);
    }

    public class_265 method_9571(class_2680 state, class_1922 reader, class_2338 pos) {
        return shapeMap.getOrDefault(state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), class_259.method_1077());
    }

    public class_265 method_25959(class_2680 state, class_1922 reader, class_2338 pos) {
        return shapeMap.getOrDefault(state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), class_259.method_1077());
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)class_25862;
            try {
                return tile.getCollisionShape();
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to get collision shape for rope knot block at {}", (Object)pos);
            }
        }
        return super.method_9549(state, world, pos, context);
    }

    protected Pair<Map<class_2680, class_265>, Map<class_2680, class_265>> makeShapes() {
        HashMap<class_2680, class_265> shapesBuilder = new HashMap<class_2680, class_265>();
        HashMap<class_2680, class_265> collisionBuilder = new HashMap<class_2680, class_265>();
        class_265 down = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 up = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        class_265 north = class_2248.method_9541((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 south = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        class_265 west = class_2248.method_9541((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 east = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        for (class_2680 state : this.field_10647.method_11662()) {
            class_265 v;
            if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) continue;
            int w = ((ModBlockProperties.PostType)((Object)state.method_11654(POST_TYPE))).getWidth();
            double o = (double)(16 - w) / 2.0;
            class_265 c = switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                default -> {
                    v = class_2248.method_9541((double)o, (double)0.0, (double)o, (double)(o + (double)w), (double)16.0, (double)(o + (double)w));
                    yield class_2248.method_9541((double)o, (double)0.0, (double)o, (double)(o + (double)w), (double)24.0, (double)(o + (double)w));
                }
                case class_2350.class_2351.field_11048 -> v = class_2248.method_9541((double)0.0, (double)o, (double)o, (double)16.0, (double)(o + (double)w), (double)(o + (double)w));
                case class_2350.class_2351.field_11051 -> v = class_2248.method_9541((double)o, (double)o, (double)0.0, (double)(o + (double)w), (double)(o + (double)w), (double)16.0);
            };
            if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)down);
            }
            if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)up);
            }
            if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)north);
            }
            if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)south);
            }
            if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)west);
            }
            if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)east);
            }
            c = class_259.method_1084((class_265)c, (class_265)v);
            c = c.method_1097();
            v = v.method_1097();
            boolean flag = true;
            for (class_265 existing : shapesBuilder.values()) {
                if (!existing.equals(v)) continue;
                shapesBuilder.put(state, existing);
                flag = false;
                break;
            }
            if (flag) {
                shapesBuilder.put(state, v);
            }
            boolean flag2 = true;
            for (class_265 existing : collisionBuilder.values()) {
                if (!existing.equals(c)) continue;
                collisionBuilder.put(state, existing);
                flag2 = false;
                break;
            }
            if (!flag2) continue;
            collisionBuilder.put(state, c);
        }
        return Pair.of((Object)ImmutableMap.copyOf(shapesBuilder), (Object)ImmutableMap.copyOf(collisionBuilder));
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 world, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        class_2680 newState = (class_2680)state.method_11657((class_2769)RopeBlock.FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.shouldConnectToFace(state, facingState, facingPos, facing, (class_4538)world)));
        class_2586 class_25862 = world.method_8321(currentPos);
        if (class_25862 instanceof RopeKnotBlockTile) {
            class_2680 newFacing;
            class_2586 class_25863;
            RopeKnotBlockTile tile = (RopeKnotBlockTile)class_25862;
            class_2680 oldHeld = tile.getHeldBlock();
            RopeKnotBlockTile otherTile = null;
            if (facingState.method_27852(ModRegistry.ROPE_KNOT.get()) && (class_25863 = world.method_8321(facingPos)) instanceof RopeKnotBlockTile) {
                RopeKnotBlockTile te2;
                otherTile = te2 = (RopeKnotBlockTile)class_25863;
                facingState = otherTile.getHeldBlock();
            }
            class_2680 newHeld = null;
            if (CompatHandler.QUARK) {
                newHeld = QuarkCompat.updateWoodPostShape(oldHeld, facing, facingState);
            }
            if (newHeld == null) {
                newHeld = oldHeld.method_26191(facing, facingState, world, currentPos, facingPos);
            }
            if (!(facingState.method_26204() instanceof IRopeConnection) && (newFacing = facingState.method_26191(facing.method_10153(), newHeld, world, facingPos, currentPos)) != facingState) {
                if (otherTile != null) {
                    otherTile.setHeldBlock(newFacing);
                    otherTile.method_5431();
                } else {
                    world.method_8652(facingPos, newFacing, 2);
                }
            }
            ModBlockProperties.PostType type = ModBlockProperties.PostType.get(newHeld);
            if (newHeld != oldHeld) {
                tile.setHeldBlock(newHeld);
                tile.method_5431();
            }
            if (newState != state) {
                tile.recalculateShapes(newState);
            }
            if (type != null) {
                newState = (class_2680)newState.method_11657(POST_TYPE, (Comparable)((Object)type));
            }
        }
        return newState;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                class_2680 class_26802 = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
                break;
            }
            case field_11465: {
                class_2680 class_26802 = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
                break;
            }
            case field_11463: {
                class_2680 class_26802 = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
                break;
            }
            default: {
                class_2680 class_26802 = state = state;
            }
        }
        if (rotation == class_2470.field_11464) {
            return state;
        }
        return switch ((class_2350.class_2351)state.method_11654(AXIS)) {
            case class_2350.class_2351.field_11048 -> (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
            case class_2350.class_2351.field_11051 -> (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            default -> super.method_9569(state, mirror);
        };
    }

    public Optional<class_2680> getRotatedState(class_2680 state, class_1936 world, class_2338 pos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        if (axis.method_10166() == class_2350.class_2351.field_11052) {
            return Optional.ofNullable(this.method_9598(state, rotation));
        }
        return Optional.empty();
    }

    public void onRotated(class_2680 newState, class_2680 oldState, class_1936 world, class_2338 pos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        class_2586 class_25862;
        if (axis.method_10166() == class_2350.class_2351.field_11052 && (class_25862 = world.method_8321(pos)) instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)class_25862;
            class_2680 mimic = tile.getHeldBlock();
            class_2680 newMimic = tile.getHeldBlock().method_26186(rotation);
            if (newMimic != mimic) {
                tile.setHeldBlock(newMimic);
                tile.method_5431();
            }
        }
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidstate = context.method_8045().method_8316(context.method_8037());
        boolean flag = fluidstate.method_15767(class_3486.field_15517) && fluidstate.method_15761() == 8;
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5998(hand).method_7909() instanceof class_1820) {
            class_2586 class_25862;
            if (!world.field_9236 && (class_25862 = world.method_8321(pos)) instanceof RopeKnotBlockTile) {
                RopeKnotBlockTile tile = (RopeKnotBlockTile)class_25862;
                RopeKnotBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)ModRegistry.ROPE.get()));
                world.method_8396(null, pos, class_3417.field_22273, class_3419.field_15248, 0.8f, 1.3f);
                world.method_8652(pos, tile.getHeldBlock(), 3);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)class_25862;
            class_2680 mimic = tile.getHeldBlock();
            return mimic.method_26204().method_9574(level, pos, state);
        }
        return super.method_9574(level, pos, state);
    }

    @Nullable
    public static class_2680 convertToRopeKnot(ModBlockProperties.PostType type, class_2680 state, class_1937 world, class_2338 pos) {
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        if (state.method_28498((class_2769)class_2741.field_12496)) {
            axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
        }
        class_2680 newState = (class_2680)((class_2680)ModRegistry.ROPE_KNOT.get().method_9564().method_11657(AXIS, (Comparable)axis)).method_11657(POST_TYPE, (Comparable)((Object)type));
        if (!world.method_8652(pos, newState = class_2248.method_9510((class_2680)newState, (class_1936)world, (class_2338)pos), 0)) {
            return null;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)class_25862;
            tile.setHeldBlock(state);
            tile.method_5431();
        }
        newState.method_30101((class_1936)world, pos, 6);
        return newState;
    }

    @Override
    public boolean canSideAcceptConnection(class_2680 state, class_2350 direction) {
        if (state.method_11654(AXIS) == class_2350.class_2351.field_11052) {
            return direction.method_10166() != class_2350.class_2351.field_11052;
        }
        return direction.method_10166() == class_2350.class_2351.field_11052;
    }
}

